#!/bin/bash

# Made by Dade Murphy (https://geeknest.ru)
# Related: https://habr.com/ru/articles/856602/

read -p "Enter Zone ID (can be found in domain overview): " ID_ZONE
read -p "Enter Global API Key (from Cloudflare profile): " GLOBAL_API_KEY
read -p "Enter Cloudflare account email: " ACCOUNT_EMAIL

echo "Sending request to Cloudflare API..."
curl -X PATCH "https://api.cloudflare.com/client/v4/zones/$ID_ZONE/settings/ech" \
     -H "X-Auth-Email: $ACCOUNT_EMAIL" \
     -H "X-Auth-Key: $GLOBAL_API_KEY" \
     -H "Content-Type:application/json" --data '{"id":"ech","value":"off"}'